	function N = BW_CONST_R_ORDER_S(Wc, Ws, Amin)
	
	% 	Computes required order for an analog lowpass Butterworth 
	%	filter with constant pole radius
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author: 		Lars Wanhammar 1999-9-27
	% 	Modified by: 	 
	% 	Copyright:		by authors - not released for commercial use
	% 	Version: 		1 
	% 	Known bugs:		 
	% 	Report bugs to:	Wanhammar@gmail.com
	
	x = 10^(0.1*Amin);
	Amax = 10*log10(x/(x-1));
	N = BW_ORDER_S(Wc, Ws, Amax, Amin);
	
